const

  {$IFDEF Win32}
    nw_netwareCalls  = 'CALWIN32.DLL'  ; 
    nw_NDSCalls      = 'NETWIN32.DLL'  ;
    nw_localeCalls   = 'LOCWIN32.DLL'  ;
    nw_netwareClx    = 'CLXWIN32.DLL'  ;
  {$ELSE}
    nw_netwareCalls  = 'NWCALLS.DLL'   ; 
    nw_NDSCalls      = 'NWNET.DLL'     ;
    nw_localeCalls   = 'NWLOCALE.DLL'  ;
  {$ENDIF}

  nw_badObject     = $0000 ;           { Object Types }
  nw_user          = $0100 ;
  nw_group         = $0200 ;
  nw_printQ        = $0300 ;
  nw_server        = $0400 ;
  nw_jobServer     = $0500 ;
  nw_gateway       = $0600 ;
  nw_printServer   = $0700 ;
  nw_archiveQueue  = $0800 ;
  nw_archiveServer = $0900 ;
  nw_jobQueue      = $0A00 ;
  nw_administration= $0B00 ;
  nw_nasSNAServer  = $2100 ;
  nw_remoteBridge  = $2600 ;
  nw_TCPIPGateway  = $2700 ;
  nw_castOn        = 0   ;             { Broadcast Modes }
  nw_castOff       = $01 ;
  nw_castOffAll    = $02 ;
  nw_castPoll      = $03 ;
  nw_format_netware       = 0   ;      { Returned Path Formats } 
  nw_format_server_volume = $01 ;
  nw_format_drive         = $02 ;
  nw_format_unc           = $03 ;

  { Internal Definitions }
  word_local              = 'Local'   ;
  word_unknown            = 'Unknown' ;
  word_none               = 'None'    ;

  { Bindery Types }
  type_set                = $02 ;
  type_item               = 0   ;

  { netware file open modes }
  nw_file_normal          = 0   ;
  nw_file_readOnly        = $01 ;
  nw_file_hidden          = $02 ;
  nw_file_system          = $04 ;
  nw_file_execute_only    = $08 ;
  nw_file_directory       = $10 ;
  nw_file_needsArchived   = $20 ;
  nw_file_shareable       = $80 ;

  { nds context keys }
  nds_key_flags           = $01 ;
  nds_key_confidence      = $02 ;
  nds_key_contextname     = $03 ;
  nds_key_transportType   = $04 ;
  nds_key_referralScope   = $05 ;

  nds_entry_browse        = $0001 ;
  nds_entry_add           = $0002 ;
  nds_entry_delete        = $0004 ;
  nds_entry_rename        = $0008 ;
  nds_entry_supervisor    = $0010 ;

  nds_attr_compare        = $0001 ;
  nds_attr_read           = $0002 ;
  nds_attr_write          = $0004 ;
  nds_attr_self           = $0008 ;
  nds_attr_supervisor     = $0020 ;

  nds_sms_scan            = $0001 ;
  nds_sms_backup          = $0002 ;
  nds_sms_restore         = $0004 ;
  nds_sms_rename          = $0008 ;
  nds_sms_delete          = $0010 ;
  nds_sms_admin           = $0020 ;

  max_rdn_chars           = 127 ;
  max_dn_chars            = 254 ;
  max_schema_name_chars   = 31  ;
  max_rdn_bytes           = (2*(max_rdn_chars+1)) ;
  max_dn_bytes            = (2*(max_dn_chars+1)) ;
  max_schema_name_bytes   = (2*(max_schema_name_chars+1)) ;
  max_asn1_name           = 31;
  max_value               = (63 * 1024) ;
  max_message             = $10000 ;
  no_more_iterations      = -1 ; {0xffffffffl}
  
  DCK_FLAGS               = 1;
  DCK_CONFIDENCE          = 2;
  DCK_NAME_CONTEXT        = 3;
  DCK_TRANSPORT_TYPE      = 4;
  DCK_REFERRAL_SCOPE      = 5;
  DCK_LAST_CONNECTION     = 8;
  DCK_LAST_SERVER_ADDRESS = 9;        (* NLM only--see NWDSIPXNetworkAddr *)
  DCK_LAST_ADDRESS_USED   = 10;       (* NLM only--above valid only if this set *)
  DCK_TREE_NAME           = 11;

  DCV_DEREF_ALIASES       = $00000001;
  DCV_XLATE_STRINGS       = $00000002;
  DCV_TYPELESS_NAMES      = $00000004;
  DCV_ASYNC_MODE          = $00000008;
  DCV_CANONICALIZE_NAMES  = $00000010;
  DCV_DEREF_BASE_CLASS    = $00000040;
  DCV_DISALLOW_REFERRALS  = $00000080;

  MAX_MESSAGE_LEN         = (63*1024);
  DEFAULT_MESSAGE_LEN     = (4*1024);

  NW_MAX_USER_NAME_LEN    = 49 ;
  NW_MAX_VOLUME_NAME_LEN  = 17 ;
  NW_MAX_SERVER_NAME_LEN  = 49 ;
  NW_MAX_TREE_NAME_LEN    = 33 ;
  NW_MAX_SERVICE_TYPE_LEN = 49 ;

  NW_CONN_TYPE            = 1;        (* returns nuint16  (VLM) *)
  NW_CONN_BIND            = $0031;
  NW_CONN_NDS             = $0032;
  NW_CONN_PNW             = $0033;
  NW_AUTHENTICATED        = 3;        (* returns nuint16  = 1 if authenticated (ALL)*)
  NW_PBURST               = 4;        (* returns nuint16  = 1 if pburst (VLM) *)
  NW_VERSION              = 8;        (* returns nuint16  (VLM)  *)
  NW_HARD_COUNT           = 9;        (* returns WORD (VLM)  *)
  NW_CONN_NUM             = 13;       (* returns nuint16  (ALL)  *)
  NW_TRAN_TYPE            = 15;       (* returns nuint16  (VLM)  *)
  NW_TRAN_IPX             = $0021;
  NW_TRAN_TCP             = $0022;
  NW_SESSION_ID           = $8000;    (* returns nuint16) (VLM) *)
  NW_SERVER_ADDRESS       = $8001;    (* returns 12 byte address (ALL) *)
  NW_SERVER_NAME          = $8002;    (* returns 48 byte string  (ALL) *)
  
  NWCC_OPEN_LICENSED      = $0001 ;
  NWCC_OPEN_UNLICENSED    = $0002 ;
  NWCC_RESERVED           = $0000 ;
  

  NWCC_NAME_FORMAT_BIND      = $0002 ;
  NWCC_NAME_FORMAT_NDS_TREE  = $0008 ; 
  NWCC_NAME_FORMAT_WILD      = $8000 ;  
  
  NWCC_INFO_AUTHENT_STATE   = 1;
  NWCC_INFO_BCAST_STATE     = 2;
  NWCC_INFO_CONN_REF        = 3;
  NWCC_INFO_TREE_NAME       = 4;
  NWCC_INFO_CONN_NUMBER     = 5;
  NWCC_INFO_USER_ID         = 6;
  NWCC_INFO_SERVER_NAME     = 7;
  NWCC_INFO_NDS_STATE       = 8;
  NWCC_INFO_MAX_PACKET_SIZE = 9;
  NWCC_INFO_LICENSE_STATE   = 10;
  NWCC_INFO_DISTANCE        = 11;
  NWCC_INFO_SERVER_VERSION  = 12;
  NWCC_INFO_VERSION         = $0001;
  
  DS_ATTRIBUTE_NAMES      = #00;
  DS_ATTRIBUTE_VALUES     = #01;
  DS_EFFECTIVE_PRIVILEGES = #02;
  DS_VALUE_INFO           = #03;
  DS_ABBREVIATED_VALUE    = #04;
            
  DS_ADD_ATTRIBUTE       = #00; (* add first value of attribute, error if it already exists *)
  DS_REMOVE_ATTRIBUTE    = #01; (* remove all values, error if attribute does not exist *)
  DS_ADD_VALUE           = #02; (* add first or additional value, error if duplicate *)
  DS_REMOVE_VALUE        = #03; (* remove a value, error if it does not exist *)
  DS_ADDITIONAL_VALUE    = #04; (* add additional value, error if duplicate or first *)
  DS_OVERWRITE_VALUE     = #05; (* add first or additional value, overwrite if duplicate *)
  DS_CLEAR_ATTRIBUTE     = #06; (* remove all values, no error if attribute does not exists *)
  DS_CLEAR_VALUE         = #07; (* remove value, no error if value does not exists *)

  DS_SEARCH_ENTRY        = 0 ;
  DS_SEARCH_SUBORDINATES = 1 ;
  DS_SEARCH_SUBTREE      = 2 ;

  FTOK_END       = 0  ;
  FTOK_OR        = 1  ;
  FTOK_AND       = 2  ;
  FTOK_NOT       = 3  ;
  FTOK_LPAREN    = 4  ;
  FTOK_RPAREN    = 5  ;
  FTOK_AVAL      = 6  ;
  FTOK_EQ        = 7  ;
  FTOK_GE        = 8  ;
  FTOK_LE        = 9  ;
  FTOK_APPROX    = 10 ;
  FTOK_ANAME     = 14 ;
  FTOK_PRESENT   = 15 ;
  FTOK_RDN       = 16 ;
  FTOK_BASECLS   = 17 ;
  FTOK_MODTIME   = 18 ;
  FTOK_VALTIME   = 19 ;


  DSV_UNUSED_0	                 = 0  ;
  DSV_RESOLVE_NAME              = 1  ;
  DSV_READ_ENTRY_INFO           = 2  ;
  DSV_READ                      = 3  ;
  DSV_COMPARE                   = 4  ;
  DSV_LIST                      = 5  ;
  DSV_SEARCH                    = 6  ;
  DSV_ADD_ENTRY                 = 7  ;
  DSV_REMOVE_ENTRY              = 8  ;
  DSV_MODIFY_ENTRY              = 9  ;
  DSV_MODIFY_RDN                = 10 ;
  DSV_DEFINE_ATTR               = 11 ;
  DSV_READ_ATTR_DEF             = 12 ;
  DSV_REMOVE_ATTR_DEF           = 13 ;
  DSV_DEFINE_CLASS              = 14 ;
  DSV_READ_CLASS_DEF            = 15 ;
  DSV_MODIFY_CLASS_DEF          = 16 ;
  DSV_REMOVE_CLASS_DEF          = 17 ;
  DSV_LIST_CONTAINABLE_CLASSES  = 18 ;
  DSV_GET_EFFECTIVE_RIGHTS      = 19 ;
  DSV_ADD_PARTITION             = 20 ;
  DSV_REMOVE_PARTITION          = 21 ;
  DSV_LIST_PARTITIONS           = 22 ;
  DSV_SPLIT_PARTITION           = 23 ;
  DSV_JOIN_PARTITIONS           = 24 ;
  DSV_ADD_REPLICA               = 25 ;
  DSV_REMOVE_REPLICA            = 26 ;
  DSV_OPEN_STREAM               = 27 ;
  DSV_SEARCH_FILTER             = 28 ;
  DSV_CREATE_SUBORDINATE_REF    = 29 ;
  DSV_LINK_REPLICA              = 30 ;
  DSV_CHANGE_REPLICA_TYPE       = 31 ;
  DSV_START_UPDATE_SCHEMA       = 32 ;
  DSV_END_UPDATE_SCHEMA         = 33 ;
  DSV_UPDATE_SCHEMA             = 34 ;
  DSV_START_UPDATE_REPLICA      = 35 ;
  DSV_END_UPDATE_REPLICA        = 36 ;
  DSV_UPDATE_REPLICA            = 37 ;
  DSV_SYNC_PARTITION            = 38 ;
  DSV_SYNC_SCHEMA               = 39 ;
  DSV_READ_SYNTAXES             = 40 ;
  DSV_GET_REPLICA_ROOT_ID       = 41 ;
  DSV_BEGIN_MOVE_ENTRY          = 42 ;
  DSV_FINISH_MOVE_ENTRY         = 43 ;
  DSV_RELEASE_MOVED_ENTRY       = 44 ;
  DSV_BACKUP_ENTRY              = 45 ;
  DSV_RESTORE_ENTRY             = 46 ;
  DSV_SAVE_DIB                  = 47 ;
  DSV_UNUSED_2                  = 48 ;
  DSV_UNUSED_3                  = 49 ;
  DSV_CLOSE_ITERATION           = 50 ;
  DSV_UNUSED_4                  = 51 ;
  DSV_AUDIT_SKULKING            = 52 ;
  DSV_GET_SERVER_ADDRESS        = 53 ;
  DSV_SET_KEYS                  = 54 ;
  DSV_CHANGE_PASSWORD           = 55 ;
  DSV_VERIFY_PASSWORD           = 56 ;
  DSV_BEGIN_LOGIN               = 57 ;
  DSV_FINISH_LOGIN              = 58 ;
  DSV_BEGIN_AUTHENTICATION      = 59 ;
  DSV_FINISH_AUTHENTICATION     = 60 ;
  DSV_LOGOUT                    = 61 ;
  DSV_REPAIR_RING               = 62 ;
  DSV_REPAIR_TIMESTAMPS         = 63 ;
  DSV_CREATE_BACKLINK           = 64 ;
  DSV_DELETE_EXTERNAL_REFERENCE = 65 ;
  DSV_RENAME_EXTERNAL_REFERENCE = 66 ;
  DSV_CREATE_ENTRY_DIR          = 67 ;
  DSV_REMOVE_ENTRY_DIR          = 68 ;
  DSV_DESIGNATE_NEW_MASTER      = 69 ;
  DSV_CHANGE_TREE_NAME          = 70 ;
  DSV_PARTITION_ENTRY_COUNT     = 71 ;
  DSV_CHECK_LOGIN_RESTRICTIONS  = 72 ;
  DSV_START_JOIN                = 73 ;
  DSV_LOW_LEVEL_SPLIT           = 74 ;
  DSV_LOW_LEVER_JOIN            = 75 ;
  DSV_ABORT_LOW_LEVEL_JOIN      = 76 ;
  DSV_GET_ALL_SERVERS           = 77 ;

  { Bindery Write Access Levels }
  BS_ANY_WRITE    = 0 ;
  BS_LOGGED_WRITE = $10 ;
  BS_OBJECT_WRITE = $20 ;
  BS_SUPER_WRITE  = $30 ;
  BS_BINDERY_WRITE= $40 ;


  { Bindery Read Access Levels }
  BS_ANY_READ     = 0 ;
  BS_LOGGED_READ  = $01 ;
  BS_OBJECT_READ  = $02 ;
  BS_SUPER_READ   = $03 ;
  BS_BINDERY_READ = $04 ;

  { Bindery Obj/Prop Flags }
  BF_STATIC       = 0   ;
  BF_DYNAMIC      = $01 ;
  BF_ITEM         = 0   ;
  BF_SET          = $02 ;

  { Trustee Rights Masks }
  TA_NONE         = $00  ;
  TA_READ         = $01  ;
  TA_WRITE        = $02  ;
  TA_OPEN         = $04  ;
  TA_CREATE       = $08  ;
  TA_DELETE       = $10  ;
  TA_OWNERSHIP    = $20  ;
  TA_SEARCH       = $40  ;
  TA_MODIFY       = $80  ;
  TA_ALL          = $A0  ;

  { Directory Inherited Rights Masks }
  TR_NONE         = $0000 ;
  TR_READ         = $0001 ;
  TR_WRITE        = $0002 ;
  TR_OPEN         = $0004 ;
  TR_CREATE       = $0008 ;
  TR_DELETE       = $0010 ;
  TR_OWNER        = $0010 ;
  TR_ACCESSCTRL   = $0020 ;
  TR_FILESCAN     = $0040 ;
  TR_MODIFY       = $0080 ;
  TR_ALL          = $01FB ;
  TR_SUPERVISOR   = $0100 ;
  TR_NORMAL       = $00FB ;

  {file attributes}
  fa_normal       = $00 ;
  fa_readOnly     = $01 ;
  fa_hidden       = $02 ;
  fa_system       = $04 ;
  fa_executeOnly  = $08 ;
  fa_directory    = $10 ;
  fa_needsArchive = $20 ;
  fa_shareable    = $80 ;
  fa_transaction  = $10 ;
  fa_indexed      = $20 ;
  fa_readAudit    = $40 ;
  fa_writeAudit   = $80 ;

  qms_auto_start    = $08 ;
  qms_entry_restart = $10 ;
  qms_entry_open    = $20 ;
  qms_user_hold     = $40 ;
  qms_operator_hold = $80 ;
  qms_any_server    = -1  ;
  qms_suppressFormFeed = $800 ;
  qms_printBanner      = $8000 ;
  qms_notifyUser       = $1000 ;
  qms_textJob          = $4000 ; {set to enable lines per page, tabs, etc flags}

  {drive status codes}
  NW_FREE_DRIVE         = $0000 ;
  NW_CDROM_DRIVE        = $0400 ;
  NW_LOCAL_FREE_DRIVE   = $0800 ;
  NW_LOCAL_DRIVE        = $1000 ;
  NW_NETWORK_DRIVE      = $2000 ;
  NW_PNW_DRIVE          = $4000 ;
  NW_NETWARE_DRIVE      = $8000 ;

  {print server connection modes}
  NWPS_BINDERY_SERVICE	 = 0 ;
  NWPS_DIRECTORY_SERVICE = 1 ;
  NWPS_BINDERY_SERVICE_PRE_40 = 2 ;

  NW_SEM_NORMAL        = 0 ;
  NW_SEM_NETWAREERROR  = 1 ;
  NW_SEM_DOSERROR      = 2 ;

  {sdk api error codes}
  NWERROR_ALREADY_ATTACHED    = $8800 ;
  NWERROR_INVALID_CONNECTION  = $8801 ;
  NWERROR_DLL_LOAD_FAILURE    = $FFFF ;

























